cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\"
set more off

use "Merged Dataset.dta", clear

*drop non-religion and those with missing religious affiliation* 
drop if (noreligion==1 | relminority==. | (noreligion==. & usa==1))

egen missexpertise = rowmiss(polknowledge polinterest polexposure)
egen missrfs = rowmiss(rfs1-rfs12)
egen missia = rowmiss(iasocial iaedu iacrime iatax)

egen expertise = rowmean(polknowledge polinterest polexposure)
replace expertise = . if missexpertise>1
egen rfs = rowmean(rfs1-rfs12)
replace rfs = . if missrfs>6
egen ia = rowmean(iasocial iaedu iacrime iatax)
replace ia = . if missia>2

*standardize independent variables*
egen zexpertise = std(expertise)
egen zrfs = std(rfs)
egen zia = std(ia)
egen zedu = std(edu)
egen zage = std(age)

*calculate percentile*
su zrfs , d



*set output directory*
cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\Results"


log using "Main - Religious Only Interactions.log"

/*================*/
/*2-way INTERACTIONS*/
/*================*/

*voting
reg voting relminority zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish

*attitude
reg attitude relminority zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish

*competence
reg competence relminority zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish

*integrity
reg integrity relminority zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) relminority=0 usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish


/*================*/
/*3-way INTERACTIONS*/
/*================*/

*voting
reg voting relminority zedu zage zexpertise zia trel##usa##c.zrfs tblending##usa##c.zrfs tseparate##usa##c.zrfs
margins, at(zrfs=(-1 1) usa=(0 1) relminority=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) relminority=0 trel=0 tblending=0 tseparate=1) atmean vsquish

*attitude
reg attitude relminority zedu zage zexpertise zia trel##usa##c.zrfs tblending##usa##c.zrfs tseparate##usa##c.zrfs
margins, at(zrfs=(-1 1) usa=(0 1) relminority=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) relminority=0 trel=0 tblending=0 tseparate=1) atmean vsquish

*integrity
reg integrity relminority zedu zage zexpertise zia trel##usa##c.zrfs tblending##usa##c.zrfs tseparate##usa##c.zrfs
margins, at(zrfs=(-1 1) usa=(0 1) relminority=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) relminority=0 trel=0 tblending=0 tseparate=1) atmean vsquish

log close

